/******************** (C) COPYRIGHT 2009 e-Design Co.,Ltd. *********************
 File Name : Draw.c       
 Version   : DS203_APP Ver 2.3x                                  Author : bure
*******************************************************************************/
#include <stdlib.h>
#include "Process.h"
#include "Draw.h"
#include "Menu.h"
#include "BIOS.h"
#include "USART.h"
trigg V_Trigg[4];
uc16 RULE_BASE [8]  ={0x020,0x040,0x080,0x040,0x020,0x010,0x008,0x010};

uc8  Mark_TAB_1[7]  ={0x00,0x00,0x42,0xFE,0x02,0x00,0x00};      // Mark 1
uc8  Mark_TAB_2[7]  ={0x00,0x46,0x8A,0x92,0x92,0x62,0x00};      // Mark 2
uc8  Mark_TAB_3[7]  ={0x00,0x44,0x82,0x92,0x92,0x6C,0x00};      // Mark 3
uc8  Mark_TAB_4[7]  ={0x00,0x18,0x28,0x4A,0xFE,0x0A,0x00};      // Mark 4
uc8  Mark_TAB_T[7]  ={0x00,0x40,0x40,0x7E,0x40,0x40,0x00};      // Mark T

uc8  Mark_TAB[5][7] ={{0x00,0x00,0x42,0xFE,0x02,0x00,0x00},    // Mark 1
                      {0x00,0x46,0x8A,0x92,0x92,0x62,0x00},    // Mark 2
                      {0x00,0x44,0x82,0x92,0x92,0x6C,0x00},    // Mark 3
                      {0x00,0x18,0x28,0x4A,0xFE,0x0A,0x00},    // Mark 4
                      {0x00,0x40,0x40,0x7E,0x40,0x40,0x00}};   // Mark T

uc16 CLK_TAB[44] =
  {0x000,0x000,0x000,0x000,0x070,0x3FF,0x070,0x000,0x000,0x000,0x000,
   0x000,0x002,0x004,0x008,0x070,0x070,0x070,0x080,0x100,0x200,0x000,
   0x020,0x020,0x020,0x020,0x070,0x070,0x070,0x020,0x020,0x020,0x020,
   0x000,0x200,0x100,0x080,0x070,0x070,0x070,0x008,0x004,0x002,0x000};

uc8 map[]=
{0x00,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x18,0x00,0x04,0x00,
 0x02,0x00,0x02,0x00,0x04,0x00,0x18,0x00,0x20,0x00,0xC0,0x00,0x00,0x01,0x00,0x02,
 0x00,0x02,0x00,0x01,0xC0,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x00,0x00,		//1
 
 0x00,0x00,0x00,0x04,0x00,0x03,0xC0,0x00,0x30,0x00,0x0C,0x00,0x02,0x00,0x0C,0x00,
 0x30,0x00,0xC0,0x00,0x00,0x03,0x00,0x04,0x00,0x03,0xC0,0x00,0x30,0x00,0x0C,0x00,
 0x02,0x00,0x0C,0x00,0x30,0x00,0xC0,0x00,0x00,0x03,0x00,0x04,0x00,0x00,0x00,0x00,		//3
 
 0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x02,0x00,0x01,0x80,0x00,0x40,0x00,0x20,0x00,
 0x10,0x00,0x08,0x00,0xFC,0x07,0x00,0x04,0x00,0x02,0x00,0x01,0x80,0x00,0x40,0x00,
 0x20,0x00,0x10,0x00,0x08,0x00,0xFC,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,		//4

 0x00,0x00,0x00,0x02,0x00,0x02,0x00,0x02,0xF8,0x03,0x08,0x00,0x08,0x00,0x08,0x00,
 0x08,0x00,0xF8,0x03,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0xF8,0x03,0x08,0x00,
 0x08,0x00,0x08,0x00,0x08,0x00,0xF8,0x03,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x00,		//2--4

 0x00,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x04,
 0x00,0x02,0x80,0x01,0x40,0x00,0x30,0x00,0x08,0x00,0x08,0x00,0x10,0x00,0x60,0x00,
 0x80,0x00,0x00,0x01,0x80,0x00,0x40,0x00,0x20,0x00,0x40,0x00,0x40,0x00,0x00,0x00,		//5
 
 0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,
 0x12,0x00,0x32,0x00,0x62,0x00,0xFE,0x03,0x60,0x02,0x30,0x02,0x10,0x02,0x00,0x02,
 0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,		//6--0
 
 0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,
 0x40,0x02,0x60,0x02,0x30,0x02,0xFE,0x03,0x32,0x00,0x62,0x00,0x42,0x00,0x02,0x00,
 0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,		//7---1
 
 0x00,0x00,0xFE,0x07,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0xFE,0x07,
 0x00,0x04,0x20,0x04,0x00,0x04,0x20,0x04,0x00,0x04,0x24,0x04,0x0C,0x04,0x3C,0x04,
 0x0C,0x04,0x24,0x04,0x00,0x04,0x20,0x04,0x00,0x04,0x20,0x04,0x00,0x00,0x00,0x00,		//11---2
 
 0x00,0x00,0xFF,0x03,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0xFF,0x03,
 0x00,0x02,0x10,0x02,0x00,0x02,0x10,0x02,0x00,0x02,0x90,0x02,0xC0,0x02,0xF0,0x02,
 0xC0,0x02,0x90,0x02,0x00,0x02,0x10,0x02,0x00,0x02,0x10,0x02,0x00,0x00,0x00,0x00,		//10---3

 0x00,0x00,0x00,0x00,0x02,0x00,0x42,0x00,0xF2,0x01,0xE2,0x00,0x42,0x00,0xFE,0x03,
 0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,
 0xFE,0x03,0x42,0x00,0xE2,0x00,0xF2,0x01,0x42,0x00,0x02,0x00,0x00,0x00,0x00,0x00,		//12---4
 
 0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0xFC,0x07,
 0x40,0x04,0xE0,0x04,0xF0,0x05,0x40,0x04,0x40,0x04,0xF0,0x05,0xE0,0x04,0x40,0x04,
 0xFC,0x07,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x00,0x00,		//13---5
 
 0x00,0x00,0x00,0x00,0x00,0x02,0x10,0x02,0x7C,0x02,0x38,0x02,0x10,0x02,0xFE,0x03,
 0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,
 0xFE,0x03,0x10,0x02,0x38,0x02,0x7C,0x02,0x10,0x02,0x00,0x02,0x00,0x00,0x00,0x00,		//8---6
 
 0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0xFE,0x03,
 0x22,0x00,0x72,0x00,0xFA,0x00,0x22,0x00,0x22,0x00,0xFA,0x00,0x72,0x00,0x22,0x00,
 0xFE,0x03,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x00,0x00,0x00};		//9---7 
 
 
uc16 Char_TAB_8x11[744] = {
  0x000,0x000,0x000,0x780,0x040,0x020,0x020,0x020, // " Ͻ
  0x020,0x020,0x040,0x780,0x000,0x000,0x000,0x000, // # Ͻ
  0x000,0x000,0x000,0x00F,0x010,0x020,0x020,0x020, // $ ½
  0x30C,0x18C,0x0C0,0x060,0x030,0x318,0x30C,0x000, // % 
  0x000,0x180,0x260,0x21C,0x26A,0x284,0x140,0x000, // & 
  0x202,0x202,0x202,0x202,0x202,0x202,0x3FE,0x000, // ' β
  0x000,0x000,0x0F8,0x1FC,0x306,0x202,0x000,0x000, // (
  0x000,0x000,0x202,0x306,0x1FC,0x0F8,0x000,0x000, // )
  0x000,0x18C,0x0D8,0x070,0x070,0x0D8,0x18C,0x000, // *  
  0x000,0x020,0x020,0x0F8,0x0F8,0x020,0x020,0x000, // + 
  0x020,0x020,0x010,0x00F,0x000,0x000,0x000,0x000, // , ½
  0x000,0x020,0x020,0x020,0x020,0x020,0x020,0x000, // -
  0x000,0x000,0x300,0x300,0x000,0x000,0x000,0x000, // .
  0x180,0x0C0,0x060,0x030,0x018,0x00C,0x006,0x000, // / 
  0x1FC,0x3FE,0x242,0x222,0x212,0x3FE,0x1FC,0x000, // 0
  0x000,0x208,0x20C,0x3FE,0x3FE,0x200,0x200,0x000, // 1
  0x304,0x386,0x2C2,0x262,0x232,0x31E,0x30C,0x000, // 2
  0x104,0x306,0x222,0x222,0x222,0x3FE,0x1DC,0x000, // 3
  0x060,0x070,0x058,0x24C,0x3FE,0x3FE,0x240,0x000, // 4
  0x11E,0x21E,0x212,0x212,0x212,0x3F2,0x1E2,0x000, // 5
  0x1F8,0x3FC,0x226,0x222,0x222,0x3E0,0x1C0,0x000, // 6
  0x006,0x006,0x3C2,0x3E2,0x032,0x01E,0x00E,0x000, // 7
  0x1DC,0x3FE,0x222,0x222,0x222,0x3FE,0x1DC,0x000, // 8
  0x01C,0x23E,0x222,0x222,0x322,0x1FE,0x0FC,0x000, // 9
  0x000,0x000,0x000,0x198,0x198,0x000,0x000,0x000, // : 
  0x2FA,0x2FA,0x2FA,0x2FA,0x2FA,0x2FA,0x2FA,0x2FA, // ; 
  0x000,0x020,0x070,0x0D8,0x18C,0x306,0x202,0x000, // <
  0x090,0x090,0x090,0x090,0x090,0x090,0x000,0x000, // =  
  0x000,0x202,0x306,0x18C,0x0D8,0x070,0x020,0x000, // >
  0x018,0x01C,0x004,0x344,0x364,0x03C,0x018,0x000, // ? 
  0x1F8,0x104,0x272,0x272,0x2F2,0x284,0x078,0x000, // @		******* 
  0x3F0,0x3F8,0x04C,0x046,0x04C,0x3F8,0x3F0,0x000, // A
  0x202,0x3FE,0x3FE,0x222,0x222,0x3FE,0x1DC,0x000, // B
  0x0F8,0x1FC,0x306,0x202,0x202,0x306,0x18C,0x000, // C
  0x202,0x3FE,0x3FE,0x202,0x306,0x1FC,0x0F8,0x000, // D
  0x202,0x3FE,0x3FE,0x222,0x272,0x306,0x38E,0x000, // E
  0x202,0x3FE,0x3FE,0x222,0x072,0x006,0x00E,0x000, // F
  0x0F8,0x1FC,0x306,0x222,0x222,0x1E6,0x3EC,0x000, // G
  0x3FE,0x3FE,0x020,0x020,0x020,0x3FE,0x3FE,0x000, // H
  0x000,0x000,0x202,0x3FE,0x3FE,0x202,0x000,0x000, // I
  0x1C0,0x3C0,0x200,0x202,0x3FE,0x1FE,0x002,0x000, // J
  0x202,0x3FE,0x3FE,0x030,0x0F8,0x3CE,0x306,0x000, // K
  0x202,0x3FE,0x3FE,0x202,0x200,0x200,0x300,0x000, // L
  0x3FE,0x3FE,0x01C,0x038,0x01C,0x3FE,0x3FE,0x000, // M
  0x3FE,0x3FE,0x01C,0x038,0x070,0x3FE,0x3FE,0x000, // N
  0x0F8,0x1FC,0x306,0x202,0x306,0x1FC,0x0F8,0x000, // O
  0x202,0x3FE,0x3FE,0x222,0x022,0x03E,0x01C,0x000, // P
  0x1FC,0x3FE,0x202,0x282,0x302,0x3FE,0x1FC,0x000, // Q
  0x202,0x3FE,0x3FE,0x022,0x062,0x3FE,0x39C,0x000, // R
  0x10C,0x31E,0x232,0x222,0x262,0x3CE,0x18C,0x000, // S
  0x000,0x00E,0x206,0x3FE,0x3FE,0x206,0x00E,0x000, // T
  0x1FE,0x3FE,0x200,0x200,0x200,0x3FE,0x1FE,0x000, // U
  0x07E,0x0FE,0x180,0x300,0x180,0x0FE,0x07E,0x000, // V
  0x0FE,0x3FE,0x380,0x1E0,0x380,0x3FE,0x0FE,0x000, // W
  0x306,0x3DE,0x0F8,0x020,0x0F8,0x3DE,0x306,0x000, // X
  0x000,0x01E,0x23E,0x3E0,0x3E0,0x23E,0x01E,0x000, // Y
  0x38E,0x3C6,0x262,0x232,0x31E,0x38E,0x000,0x000, // Z
  0x200,0x300,0x2C0,0x220,0x218,0x204,0x3FE,0x000, // [        
  0x000,0x022,0x042,0x1FE,0x3FE,0x240,0x220,0x000, // \½   
  0x020,0x010,0x008,0x006,0x008,0x010,0x020,0x020, // ] ָ    
  0x000,0x220,0x210,0x3FC,0x3FE,0x012,0x022,0x000, // ^   
  0x000,0x200,0x200,0x200,0x200,0x200,0x200,0x000, // _ º  
  0x202,0x202,0x202,0x202,0x202,0x202,0x202,0x202, // ` 
  0x1C0,0x3E8,0x228,0x228,0x1F8,0x3F0,0x200,0x000, // a         
  0x202,0x3FE,0x1FE,0x220,0x220,0x3E0,0x1C0,0x000, // b 
  0x1E0,0x3F0,0x210,0x210,0x210,0x330,0x120,0x000, // c 
  0x000,0x1C0,0x3E0,0x220,0x222,0x3FE,0x3FE,0x000, // d 
  0x1E0,0x3F0,0x250,0x250,0x250,0x370,0x160,0x000, // e 
  0x000,0x220,0x3FC,0x3FE,0x222,0x002,0x004,0x000, // f
  0x130,0x378,0x248,0x248,0x3F8,0x1F8,0x000,0x000, // g
  0x202,0x3FE,0x3FE,0x020,0x010,0x3F0,0x3E0,0x000, // h
  0x000,0x000,0x200,0x3F6,0x3F6,0x200,0x000,0x000, // i 
  0x000,0x100,0x300,0x210,0x3F6,0x1F6,0x000,0x000, // j
  0x202,0x3FE,0x3FE,0x062,0x0F0,0x398,0x308,0x000, // k
  0x000,0x000,0x202,0x3FE,0x3FE,0x200,0x000,0x000, // l
  0x3F8,0x3F8,0x018,0x3F0,0x018,0x3F8,0x3F0,0x000, // m 
  0x008,0x3F8,0x3F0,0x008,0x008,0x3F8,0x3F0,0x000, // n 
  0x000,0x1F0,0x3F8,0x208,0x208,0x3F8,0x1F0,0x000, // o
  0x208,0x3F8,0x3F0,0x248,0x048,0x078,0x030,0x000, // p 
  0x030,0x078,0x048,0x248,0x3F8,0x3F8,0x200,0x000, // q
  0x208,0x3F8,0x3F0,0x218,0x008,0x018,0x030,0x000, // r 
  0x000,0x110,0x338,0x268,0x248,0x3D8,0x190,0x000, // s 
  0x010,0x010,0x1F8,0x3FC,0x210,0x310,0x100,0x000, // t
  0x1F8,0x3F8,0x200,0x200,0x1F8,0x3F8,0x200,0x000, // u 
  0x000,0x0F8,0x1F8,0x300,0x300,0x1F8,0x0F8,0x000, // v
  0x0F8,0x3F8,0x300,0x180,0x300,0x3F8,0x0F8,0x000, // w
  0x208,0x318,0x1B0,0x0E0,0x1B0,0x318,0x208,0x000, // x
  0x038,0x278,0x240,0x240,0x240,0x1F8,0x0F8,0x000, // y
  0x318,0x388,0x2C8,0x268,0x238,0x318,0x000,0x000, // z 
  0x0F8,0x088,0x38E,0x022,0x2FA,0x2FA,0x2FA,0x2FA, // { ͷ
  0x000,0x000,0x000,0x3FE,0x3FE,0x000,0x000,0x000, // | 
  0x2FA,0x2FA,0x2FA,0x2FA,0x2FA,0x202,0x3FE,0x000, // } β
  0x0F8,0x088,0x38E,0x202,0x202,0x202,0x202,0x202};// ~ յͷ

uc8  Ref_Wave [360] =   //
{100,116,130,144,157,167,175,181,185,185,184,179,173,164,153,141,128,114,100, 86,
  73, 60, 49, 40, 33, 27, 24, 24, 25, 29, 35, 43, 52, 63, 75, 87,100,112,124,135,
 145,153,160,164,167,167,166,163,157,150,142,133,122,111,100, 89, 79, 70, 61, 54,
  48, 44, 42, 42, 43, 46, 50, 57, 64, 72, 81, 90,100,109,118,126,133,139,144,147,
 149,149,148,146,142,137,130,124,116,108,100, 93, 85, 79, 73, 68, 64, 61, 60, 60,
  61, 63, 66, 70, 75, 81, 87, 93,100,106,112,117,122,125,128,130,131,131,131,129,
 126,123,119,115,110,105,100, 96, 91, 88, 84, 81, 79, 78, 77, 78, 78, 80, 82, 84, 
  87, 90, 93, 97,100,103,106,108,110,112,113,114,114,113,113,112,110,109,107,105,
 104,102,100,99, 97, 96, 96, 95, 95, 95, 95, 96, 96, 97, 97, 98, 99, 99, 100,100,
 100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
 100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
 100,100,100,100,100,115,129,141,151,160,165,169,170,169,167,162,156,148,139,130,
 120,110,100, 91, 82, 75, 68, 63, 59, 57, 56, 56, 58, 61, 64, 69, 75, 81, 87, 94,
 100,106,112,117,121,125,127,129,130,130,128,127,124,121,117,113,109,104,100, 96, 
  92, 88, 85, 83, 81, 80, 79, 79, 80, 81, 83, 85, 88, 91, 94, 97,100,103,106,108,
 100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
 100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
 100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,};

u16 Palette[] ={CYAN,   YEL,   PURPL,  GRN, // Ļʾɫ嶨  
                CYAN_,  YEL_,  PURPL_, GRN_,        
                BLACK,  RED,   WHT,    GRN,   
                BLUE,   GRAY,  ORANGE, DARK};   

extern u8  TrackBuff[X_SIZE * 4];                  // ʾ켣: i+0,i+1,i+2,i+3,ֱ14Ź켣
                   
u16 HueNum[4]={GRAY,CYAN,YEL,PURPL};    // ʾɫţcolor(0~1)bit,͸0/12~3)bit
u16 Buffer1[201], Buffer2[201];             // Ļʾл 
u32 Block[1500];                            // ʾʾ
s16 Bx1, Bx2, By1, By2;                     // ʾĻʾеʼλ
u16 Nx0, Ny0;                               // ʾϢǰʾλ
u8  BLOCK_HIDE = 0;                         // ʾʾ/־

u16 T0Posi  =T0_POSI,T0_PerCnt=T0_POSI  ;                          // ˮƽλ150,120
u16 T1Posi  = 80;                           // T1αλ 51
u16 T2Posi  = 280;                          // T2αλ 220
u16 VtColor ;                          // źԴɫ= YEL
  
u16 Vt      ;                           // ƽ־λ= 53
u16 Vv1    = 160 ;                          // V1αλ
u16 Vv2   = 40  ;                           // V2αλ
  
u8  Vt_HIDE = 0;                            // ƽʾ/־
u8  V1_HIDE = 0;                            // V1αʾ/־
u8  V2_HIDE = 0;                            // V2αʾ/־
u8  T0_HIDE = 0;                            // ˮƽλʾ/־
u8  T1_HIDE = 0;                            // T1αʾ/־
u8  T2_HIDE = 0;                            // T2αʾ/־
  
u8  Show[4] = {1, 1, 1, 1};                 // Track1~4켣ʾ/־

/*******************************************************************************
 NotePixl: ʾó   HueNum: ɫ(0x0~0x3)  ضλ: Nx0, Ny0
*******************************************************************************/
void NotePixl(u8 HueNum)
{
  u16 i, j;
  i = Nx0*((By2 - By1 + 15)/16) + Ny0/16;
  j = 2*(Ny0%16);
  Block[i] &= ~(3<<j);
  Block[i] |= HueNum<<j;
  Ny0++;
  if(Ny0 ==(By2-By1)){
    Ny0=0;  Nx0++;
  }
}
/*******************************************************************************
 NoteChar: ʾַӡ  HueNum = ɫ(0x0~0x3)<<2 + ǰɫ(0x0~0x3)
*******************************************************************************/
void NoteChar(u8 HueNum, u8 Inv, u8 Char)
{
  u16 i, j, b; 
  
  Nx0--;
  for (i=0; i<14; i++){       // ַǰһհ 
    (Inv)? NotePixl(HueNum &3): NotePixl(HueNum>>2); 
  }
  Nx0++; Ny0 -= 14; 
  for(i=0; i<8; i++){
    b = (Char <= 0x21)? 0 : __Get_TAB_8x14(Char, i);
    if((Char == 0x21)&&(i == 4)) break;
    for(j=0; j<14; ++j){
      if((b >> j)& 0x04) 
        (Inv)? NotePixl(HueNum>>2): NotePixl(HueNum &3); 
      else 
        (Inv)? NotePixl(HueNum &3): NotePixl(HueNum>>2); 
    }
    Nx0++; Ny0 -= 14;                           
  }
}
/*******************************************************************************
 NoteSTR: ʾַӡ
*******************************************************************************/
void NoteSTR(u8 HueNum, u8 Inv, u8 *s)
{ 
  while (*s!=0) {
    NoteChar(HueNum, Inv, *s);
    ++s;                          
  }
}
/*******************************************************************************
 NoteSide: ʾ߿ӡ  HueNum = ɫ(0x0~0x3)<<2 + ǰɫ(0x0~0x3)
*******************************************************************************/
void NoteSide(u8 HueNum)
{ 
  u16 x, y;
  
  for(x=1; x<(Bx2-Bx1-1); x++){
    Nx0 = x;  Ny0 = 1;
    for(y=1; y<(By2-By1-1); y++) NotePixl(HueNum >>2);
  }  
  for(x=2; x<(Bx2-Bx1-1); x++) {
    Nx0 = x;  Ny0 = 0;
    NotePixl(HueNum);
    Nx0 = x;  Ny0 = (By2-By1-1);
    NotePixl(HueNum);
  }
  Nx0 = 0;  Ny0 = 2;
  for(y=2; y<(By2-By1-1); y++) NotePixl(HueNum);
  Nx0 = Bx2-Bx1-1;  Ny0 = 2;
  for(y=2; y<(By2-By1-1); y++) NotePixl(HueNum);
  
  Nx0 = 1;  Ny0 = 1;
  NotePixl(HueNum);
  Nx0 = Bx2-Bx1-2;  Ny0 = 1;
  NotePixl(HueNum);

  Nx0 = 1;  Ny0 = By2-By1-2;
  NotePixl(HueNum);
  Nx0 = Bx2-Bx1-2;  Ny0 = By2-By1-2;
  NotePixl(HueNum);
}

/*******************************************************************************
 Get_TAB_8x11
*******************************************************************************/
u16 Get_TAB_8x11(u8 Code, u8 Row)
{
  return Char_TAB_8x11[((Code-0x22)*8)+Row];
}
/*******************************************************************************
 Get_Ref_Wave: 
*******************************************************************************/
u8 Get_Ref_Wave(u16 i)
{
  return Ref_Wave[i];
}
/*******************************************************************************
 Print_Clk: ָʾ
*******************************************************************************/
void Print_Clk(u16 x0, u16 y0, u16 Type, u8 Phase)
{
  u16 i, j, b;
  
  __LCD_Set_Block(x0, x0+10, y0, y0+10);
  for(i=0; i<11; ++i){
    b = CLK_TAB[Phase *11 + i];
    for(j=0; j<11; ++j){
      if((b >> j)& 0x001) __LCD_SetPixl(Palette[Type >> 0x8]);
      else                __LCD_SetPixl(Palette[Type & 0x0F]);
    }
  }
  __LCD_Set_Block(LCD_X1,LCD_X2,LCD_Y1,LCD_Y2);  //ָȫߴ細
}
/*******************************************************************************
 Print_Str: 
*******************************************************************************/
void Print_Str(u16 x0, u16 y0, u8 HueNum, u8 Inv, u8 *s)
{ 
  u8 j;
  __Point_SCR(x0-1, y0);  
  for (j=0; j<11;++j){ 
    __LCD_SetPixl(Palette[(Inv)?(HueNum >> 4):(HueNum & 0x0F)]); //
  }
  while(*s != 0){
    Print_Char(x0, y0, HueNum, Inv, *s);
    x0 += (*s == 0x21)? 4 : 8; 
    ++s;                           //ַָ+1
  }
}
/*******************************************************************************
 Print_Str: 
*******************************************************************************/
void Print_Map(u16 x0, u16 y0, u8 HueNum, u8 Inv, u8 Char)
{ 
  u16 i, j, b; 
	u16* ptr;
  ptr=(u16*)&map[Char*48];
  for(i=0; i<24; i++)
  {
  		b= ptr[i];
    	__Point_SCR(x0, y0);
    	for(j=0; j<12; j++)
    	{
      	if((b << j)& 0x800) 
        	__LCD_SetPixl(Palette[(Inv)?(HueNum & 0x0F):(HueNum >> 4)]); 
      	else
        __LCD_SetPixl(Palette[(Inv)?(HueNum >> 4):(HueNum & 0x0F)]); 
    	}
    	x0++;
  }
}

void Print_CharMap(u16 x0, u16 y0, u8 HueNum, u8 Inv, u8 Char)
{ 
  u16 i, j, b; 
	u16* ptr;
  ptr=(u16*)&map[Char*48];
  for(i=0; i<24; i++)
  {
  		b= ptr[i];
    	__Point_SCR(x0, y0);
    	for(j=0; j<11; j++)
    	{
      	if((b << j)& 0x400) 
        	__LCD_SetPixl(Palette[(Inv)?(HueNum & 0x0F):(HueNum >> 4)]); 
      	else
        __LCD_SetPixl(Palette[(Inv)?(HueNum >> 4):(HueNum & 0x0F)]); 
    	}
    	x0++;
  }
}

void Print_Char(u16 x0, u16 y0, u8 HueNum, u8 Inv, u8 Char)
{ 
  u16 i, j, b; 

  __LCD_Set_Block(x0, x0+7, y0, y0+10);
  for(i=0; i<8; i++){
    b = (Char <= 0x21)? 0 : Get_TAB_8x11(Char, i);
    if((Char == 0x21)&&(i == 4)) break;
    for(j=0; j<11; j++){
      if((b << j)& 0x400) 
        __LCD_SetPixl(Palette[(Inv)?(HueNum & 0x0F):(HueNum >> 4)]); 
      else
        __LCD_SetPixl(Palette[(Inv)?(HueNum >> 4):(HueNum & 0x0F)]); 
    }
  }
  __LCD_Set_Block(LCD_X1,LCD_X2,LCD_Y1,LCD_Y2);  //ָȫߴ細
}

/*******************************************************************************
 Print_Str: 
*******************************************************************************/
/*void Print_Str(u16 x0, u16 y0, u16 Type, u8 Mode, u8 *s)
{ 
  signed short i, j, b; 
  __LCD_Set_Block(x0, LCD_X2, y0, y0+10);
  for (j=0; j<11;++j){ 
    if(Mode == 0) __LCD_SetPixl(Color[Type & 0x0F]);   //Normal replace Display
    else          __LCD_SetPixl(Color[Type >> 0x8]);   //Inverse replace Display
  }
  x0++;                            // ÿһַǰһհ 
  while (*s!=0) {
    for(i=0;i<8;++i){
      if((*s==0x20)||(*s==0x21)) b = 0x0000;
      else                       b = Get_TAB_8x11(*s, i);
      if((*s==0x21)&&(i==4)) break;
      for(j=0;j<11;++j){
        if((b << j)& 0x400) {
          if(Mode == 0) __LCD_SetPixl(Color[Type >> 0x8]);
          else          __LCD_SetPixl(Color[Type & 0x0F]);
        } else {
          if(Mode == 0) __LCD_SetPixl(Color[Type & 0x0F]);
          else          __LCD_SetPixl(Color[Type >> 0x8]);
        }
      }
    }
    if(*s==0x21) x0 +=4;           //ʾλˮƽ+4
    else  x0 += 8;                 //ʾλˮƽ+8
    ++s;                           //ַָ+1
  }
  __LCD_Set_Block(LCD_X1,LCD_X2,LCD_Y1,LCD_Y2);  //ָȫߴ細
}*/

/*******************************************************************************
 Draw_Window :  
*******************************************************************************/
void Draw_Window(void)				
{ 
  s16  i, j, d, Row;
  u8   k[4], m[4], n[4], b[4], Hide[4];
  u32* p;


  for(Row = X_BASE; Row <= X_SIZE; Row++){	
    p =(Row - Bx1)*((By2 - By1)/16)+ Block;
    for(i=0; i<4; i++){
      m[i]= b[i];                                     // ȡǰй켣 
      n[i] = TrackBuff[Row*4 + i];                     // ȡй켣
      b[i]= n[i];                                     // ݱй켣 
      Hide[i]= 0;
      if(n[i] - m[i] < 0){                            // С
        n[i] = m[i];      
        m[i] = b[i];
      }    
      else if(n[i] == m[i]){       
        (n[i] > Y_SIZE - 2)?(Hide[i]= 1):(n[i]++);    //  or ˮƽ߼Ӵ
        (n[i] < Y_BASE + 2)?(Hide[i]= 1):(m[i]--);
      }
      k[i] = i;                                       // ɫʱ
      if((n[i]- m[i]) > 5)  k[i] += 4;                // ɫʱ
    }
     // ΪDMAͻ湤  
    if((Row >= X_SIZE-1)||(Row == X_BASE))  __LCD_DMA_Ready(); // ͬ
    if(Row & 1){ // д
      __Row_DMA_Ready();                              // ȺDMA
      Buffer2[Y_BASE] = Palette[13];
      Buffer2[Y_SIZE] = Palette[13];
      for(i=0; i<4; i++){
        if((Hide[i] == 0)&&(Show[i])){
          for(; m[i]<=n[i]; m[i]++) Buffer2[m[i]] |= Palette[k[i]];
        }
      }
      if((Row == X_BASE + 1)||(Row == X_SIZE - 1)){   // ѹα˵ 
        Buffer2[Vv1] |= Palette[VERNIE];
        Buffer2[Vv2] |= Palette[VERNIE];
        Buffer2[Vt]  |= VtColor;                      // ѹα˵
      }
      if(Row%3 == 0){
        if(!V1_HIDE) Buffer2[Vv1] |= Palette[VERNIE];   // ѹα 
        if(!V2_HIDE) Buffer2[Vv2] |= Palette[VERNIE]; 
        if(!Vt_HIDE) Buffer2[Vt]  |= VtColor;         // ѹα 
      }
      if(Row == T0Posi){                              // λα
        if(T0_HIDE == 0){ 
          for(i=1; i<=Y_SIZE; i+=3) Buffer2[i] |= Palette[X_POSI]; 
        }
        Buffer2[Y_SIZE]   = Palette[X_POSI];            // λα˵
        Buffer2[Y_SIZE-1] = Palette[X_POSI];
        Buffer2[Y_BASE+1] = Palette[X_POSI];
        Buffer2[Y_BASE]   = Palette[X_POSI];
      }
      if((Row == T0Posi-1)||(Row == T0Posi+1)){
        Buffer2[Y_SIZE] = Palette[X_POSI];
        Buffer2[Y_BASE] = Palette[X_POSI];
      }
      if((Row == T1Posi)&&(T1_HIDE == 0)){            // ʱα
        for(i=1; i<=Y_SIZE; i+=3) Buffer2[i] |= Palette[VERNIE];
      }
      if((Row == T2Posi)&&(T2_HIDE == 0)){
        for(i=1; i<=Y_SIZE; i+=3) Buffer2[i] |= Palette[VERNIE];
      }
      if((Row == T1Posi)||(Row == T2Posi)){           // ʱα˵                
        Buffer2[Y_SIZE]   = Palette[VERNIE];
        Buffer2[Y_SIZE-1] = Palette[VERNIE];
        Buffer2[Y_BASE+1] = Palette[VERNIE];
        Buffer2[Y_BASE]   = Palette[VERNIE];
      }
      if((Row == T1Posi-1)||(Row == T1Posi+1)||
        ( Row == T2Posi-1)||(Row == T2Posi+1)){
        Buffer2[Y_SIZE] = Palette[VERNIE];
        Buffer2[Y_BASE] = Palette[VERNIE];
      }
      if(!BLOCK_HIDE){
        if((Row >= Bx1)&&(Row < Bx2)){                // ӶԻBlock
          for(i=By1; i<By2; i+=16){
            for(j=0; j<32; j+=2){
              d = i + j/2;
              if((d > Y_BASE)&&(d < Y_SIZE))
                Buffer2[d] = HueNum[(*p >> j) & 3];    //Buffer2[d] |= HueNum[(*p >> j) & 3](͸)
            }
            p++;
          }    
        }
      }
      __LCD_DMA_Ready();
      if((Row+1) == X_SIZE) __Row_Fill(&Palette[13], Buffer1); // DMAȫɫ
      else __Row_Fill(&Palette[8], Buffer1);                   // DMAȫհ
      __Point_SCR(MIN_X + Row, MIN_Y + 1);            // ʼλ
      __LCD_Copy(Buffer2, Y_SIZE+1);                  // DMAݵLCD
      
    } else {     // żд
      __Row_DMA_Ready();                              // ȺDMA
//      if(Row%30 == 0) for(i=6; i<200; i+=6) Buffer1[i] = GRAY;
      if(Row%30 == 0) for(i=5; i<200; i+=5) Buffer1[i] = GRAY;
//      else if(Row%6  == 0) for(i=30; i<200; i+=30) Buffer1[i] = GRAY;
      else if(Row%6  == 0) for(i=25; i<200; i+=25) Buffer1[i] = GRAY;
      Buffer1[Y_BASE] = Palette[13];                         // ˮƽ
      Buffer1[Y_SIZE] = Palette[13];                         
      if((Row != X_BASE)&&(Row != X_SIZE)){ 
        for(i=0; i<4; i++){
          if((Hide[i] == 0)&&(Show[i])){
            for(; m[i]<=n[i]; m[i]++) Buffer1[m[i]] |= Palette[k[i]]; 
          }
        }
      }
      if(Row%3 == 0){
        if(!V1_HIDE) Buffer1[Vv1] |= Palette[VERNIE];   // ѹα 
        if(!V2_HIDE) Buffer1[Vv2] |= Palette[VERNIE]; 
        if(!Vt_HIDE) Buffer1[Vt]  |= VtColor;         // ѹα 
      }
      if((Row == X_BASE)||(Row == X_SIZE)){ 
        Buffer1[Vv1 + 1] |= Palette[VERNIE];            // ѹα˵
        Buffer1[Vv1]     |= Palette[VERNIE];
        Buffer1[Vv1 - 1] |= Palette[VERNIE];
        Buffer1[Vv2 + 1] |= Palette[VERNIE];
        Buffer1[Vv2]     |= Palette[VERNIE];
        Buffer1[Vv2 - 1] |= Palette[VERNIE];
        Buffer1[Vt + 1]  |= VtColor;                  // ѹα˵
        Buffer1[Vt]      |= VtColor;
        Buffer1[Vt - 1]  |= VtColor;
      }
      if(Row == T0Posi){                              // λα
        if(T0_HIDE == 0){ 
          for(i=1; i<=Y_SIZE; i+=3) Buffer1[i] |= Palette[X_POSI]; 
        }
        Buffer1[Y_SIZE]   = Palette[X_POSI];            // λα˵
        Buffer1[Y_SIZE-1] = Palette[X_POSI];
        Buffer1[Y_BASE+1] = Palette[X_POSI];
        Buffer1[Y_BASE]   = Palette[X_POSI];
      }
      if((Row == T0Posi-1)||(Row == T0Posi+1)){
        Buffer1[Y_SIZE] = Palette[X_POSI];
        Buffer1[Y_BASE] = Palette[X_POSI];
      }
      if((Row == T1Posi)&&(T1_HIDE == 0)){            // ʱα
        for(i=1; i<Y_SIZE; i+=3) Buffer1[i] |= Palette[VERNIE];
      }
      if((Row == T2Posi)&&(T2_HIDE == 0)){
        for(i=1; i<Y_SIZE; i+=3) Buffer1[i] |= Palette[VERNIE];
      }
      if((Row == T1Posi)||(Row == T2Posi)){           // ʱα˵                
        Buffer1[Y_SIZE]   = Palette[VERNIE];
        Buffer1[Y_SIZE-1] = Palette[VERNIE];
        Buffer1[Y_BASE+1] = Palette[VERNIE];
        Buffer1[Y_BASE]   = Palette[VERNIE];
      }
      if((Row == T1Posi-1)||(Row == T1Posi+1)||
        ( Row == T2Posi-1)||(Row == T2Posi+1)){
        Buffer1[Y_SIZE] = Palette[VERNIE];
        Buffer1[Y_BASE] = Palette[VERNIE];
      }
      if(!BLOCK_HIDE){
        if((Row >= Bx1)&&(Row < Bx2)){                // ӶԻBlock
          for(i=By1; i<By2; i+=16){
            for(j=0; j<32; j+=2){
              d = i + j/2;
              if((d > Y_BASE)&&(d < Y_SIZE))
                Buffer1[d] = HueNum[(*p >> j) & 3];///??????????????????????
            }
            p++;
          }    
        }
      }
      __LCD_DMA_Ready();
      __Row_Fill(&Palette[8], Buffer2);                     // DMAȫհ
      __Point_SCR(MIN_X + Row, MIN_Y + 1);            // ʼλ
      __LCD_Copy(Buffer1, Y_SIZE+1);                  // DMAżݵLCD
    }
  }     
  __Row_Fill(&Palette[13], Buffer1);                         // DMA䴹ֱ
}       
/*******************************************************************************
 Draw_Mark :  
*******************************************************************************/
void Draw_Mark(u16 m, u16 n)						
{ 
  u16 i, j, Tmp;

 
  if(m < 4)  if(Title[m][POSI].Value > (200-3)) return;
  else       if(V_Trigg[n].Value > (200-3))     return;  ////////////////////
  
  for(i = 0; i <= 10; ++i){
    if(i < 7){
      if(m < 4){
        Tmp = Mark_TAB[m][i];
        __Point_SCR(i, Title[m][POSI].Value +(MIN_Y-4));
      } 
      else { //////////////////////
        Tmp = Mark_TAB[4][i];
        __Point_SCR(i,     V_Trigg[n].Value +(MIN_Y-4));
      }  /////////////////////
      for(j = 0; j < 8; ++j){
        if(Tmp & 1) __LCD_SetPixl(Palette[SCRN]);
        else        __LCD_SetPixl(Palette[n]);
        Tmp >>= 1;
      }
      __LCD_SetPixl(Palette[n]);
    } else {
      if(m < 4){
        __Point_SCR(i,  Title[m][POSI].Value+(MIN_Y-10)+ i);//
        for(j=Title[m][POSI].Value+(MIN_Y-10)+i;j<(Title[m][POSI].Value+(MIN_Y+11)-i);++j) 
          __LCD_SetPixl(Palette[n]); 
      } 
      else {                                                      //////////////////////////////
        __Point_SCR(i, V_Trigg[n].Value +(MIN_Y-10)+ i);   
        for(j=V_Trigg[n].Value+(MIN_Y-10)+i;j<(V_Trigg[n].Value+(MIN_Y+11)-i);++j) 
          __LCD_SetPixl(Palette[n]); //
      }                                                          ///////////////////////////
    }
  }
}
/*******************************************************************************
 Update_Mark :  
*******************************************************************************/
void Update_Mark(void)						
{ 
  s16 i, Tmp; 
  u8  j;

  static u8 old;
  __Row_DMA_Ready();
  for(i = 0; i <= 10; ++i){
    __Point_SCR(i, MIN_Y-1);
    for(j = MIN_Y-1; j < MAX_Y+2; ++j)  __LCD_SetPixl(Palette[SCRN]);   // Clear row
  }
  if(_1_source  != HIDE)    Draw_Mark(TRACK1, TRACK1); // Display Track1 mark
  if(_2_source  != HIDE)    Draw_Mark(TRACK2, TRACK2); // Display Track1 mark
  if(_3_source  != HIDE)    Draw_Mark(TRACK3, TRACK3); // Display Track1 mark
  if(_4_source  != HIDE)    Draw_Mark(TRACK4, TRACK4); // Display Track1 mark
  if(_Tr_source == TRACK1)  Draw_Mark(TRIGG,  TRACK1); // Display Trigg1 mark  //////////////////
  if(_Tr_source == TRACK2)  Draw_Mark(TRIGG,  TRACK2); // Display Trigg1 mark  //////////////////
  if(_Tr_source<TRACK3)old=_Tr_source;
  else
    Draw_Mark(TRIGG,  old);
  //if(_Tr_source == TRACK3)  Draw_Mark(TRIGG,  TRACK3); // Display Trigg1 mark  /////////////////
  //if(_Tr_source == TRACK4)  Draw_Mark(TRIGG,  TRACK4); // Display Trigg1 mark  /////////////////
     
  __Point_SCR(MAX_X+1, MIN_Y-1);
  for(j = MIN_Y-1; j < MAX_Y+2; ++j) __LCD_SetPixl(Palette[SCRN]); // Clear last row 
  for(i = MIN_X; i <= MAX_X+1; ++i)
  {
    __Point_SCR(i, MIN_Y-1);
    __LCD_SetPixl(Palette[SCRN]);                            // Clear first column
    __Point_SCR(i, MAX_Y);
    __LCD_SetPixl(Palette[SCRN]);                            // Clear last column
  }

  __Point_SCR(MIN_X-1, Trigg[V_VERNIE1].Value1 +(MIN_Y-1));//Title[V_VERNIE][V1].Value 
  for(i = 0; i < 5; ++i) __LCD_SetPixl(Palette[VERNIE]);
  __Point_SCR(MIN_X-1,  Trigg[V_VERNIE2].Value1+(MIN_Y-1 )); //Title[V_VERNIE][V2].Value
  for(i = 0; i < 5; ++i) __LCD_SetPixl(Palette[VERNIE]);
  __Point_SCR(MAX_X+1,  Trigg[V_VERNIE1].Value1+(MIN_Y- 1 ));//Title[V_VERNIE][V1].Value
  for(i = 0; i < 5; ++i) __LCD_SetPixl(Palette[VERNIE]);
  __Point_SCR(MAX_X+1,  Trigg[V_VERNIE2].Value1+(MIN_Y- 1 ));//Title[V_VERNIE][V2].Value
  for(i = 0; i < 5; ++i) __LCD_SetPixl(Palette[VERNIE]);
 
  if( Trigg[T0].Value1==0)T0_PerCnt=T0_POSI;
  if( Trigg[T0].Value1==1)T0_PerCnt=BufModulus[Trigg[TRIGG_BUF].Value2]/2-T0_POSI;
  if( Trigg[T0].Value1==2)T0_PerCnt=BufModulus[Trigg[TRIGG_BUF].Value2]-T0_POSI-Xv[Trigg[TRIGG_BUF].Value2];//ldiv(BufModulus[Trigg[TRIGG_BUF].Value2]-T0_POSI,360).rem;	
	T0Posi=T0_PerCnt-_X_posi.Value*30;
	
  /*Tmp =(MIN_X + 150)- _X_posi.Value;
  if(Tmp > MIN_X){
    for(i = Tmp - 2; i <= Tmp + 2; ++i){
      __Point_SCR(i, MIN_Y-1);
      __LCD_SetPixl(Palette[X_POSI]);
      __Point_SCR(i, MAX_Y+1);
      __LCD_SetPixl(Palette[X_POSI]);
    }
  }*/
  Tmp = MIN_X + Trigg[T_VERNIE1].Value1;//Title[T_VERNIE][T1].Value
  for(i = Tmp - 2; i <= Tmp + 2; ++i){
    __Point_SCR(i, MIN_Y-1);
    __LCD_SetPixl(Palette[VERNIE]);
    __Point_SCR(i, MAX_Y+1);
    __LCD_SetPixl(Palette[VERNIE]);
  }
  Tmp = MIN_X + Trigg[T_VERNIE2].Value1;//Title[T_VERNIE][T2].Value
  for(i = Tmp - 2; i <= Tmp + 2; ++i){
    __Point_SCR(i, MIN_Y-1);
    __LCD_SetPixl(Palette[VERNIE]);
    __Point_SCR(i, MAX_Y+1);
    __LCD_SetPixl(Palette[VERNIE]);
  }
}
/*******************************************************************************
 Update_View_Area: ˢʾλָʾ 
*******************************************************************************/
void Update_View_Area(void)
{  
  s16 i, j, k;
  s16 x0,x1,y0;
  u32 color;
  {

    x0=226;y0=216,color=ORANGE;
    x1=396;
    __LCD_DMA_Ready();
    __Point_SCR(x0,  y0);
    for(j=0; j<12; ++j) __LCD_SetPixl(color); 
    __Point_SCR(x0+1,  y0);
    for(j=0; j<12; ++j) __LCD_SetPixl(color); 

    __Point_SCR(x1, 216);
    for(j=0; j<12; ++j) __LCD_SetPixl(color); 
    __Point_SCR(x1+1, 216);
    for(j=0; j<12; ++j) __LCD_SetPixl(color); 
  

   for(i=x0+2; i<x1-1; i+=8){
      for(j=0; j<8; ++j){
        __Point_SCR(i+j, y0);
        for(k=0; k<12; ++k){
          if((0x01 << k)& RULE_BASE[j]) __LCD_SetPixl(color);
          else                          __LCD_SetPixl(BLACK);
        }
      }
    }
    __Point_SCR(((x0+3) + (_X_posi.Value *168/136)), y0);   
    for(j=0;j<9;++j) __LCD_SetPixl(WHT);
    __Point_SCR((15 + (x0+3) + (_X_posi.Value *168/136)), y0);
    for(j=0;j<9;++j) __LCD_SetPixl(WHT);
    for(i=0;i<16;++i){
      __Point_SCR((i + (x0+3) +(_X_posi.Value *168/136)), y0);
      __LCD_SetPixl(WHT);
      __Point_SCR((i + (x0+3) +(_X_posi.Value *168/136)), (y0+9));
      __LCD_SetPixl(WHT);
    }
		if( Trigg[T0].Value1==0)x0=229+(T0_POSI/30)*168/136;
		if( Trigg[T0].Value1==1)x0=229+(((BufModulus[Trigg[TRIGG_BUF].Value2]/2-T0_POSI)/30)*168/136);	
		if( Trigg[T0].Value1==2)x0=229+(((BufModulus[Trigg[TRIGG_BUF].Value2]-T0_POSI-Xv[Trigg[TRIGG_BUF].Value2])/30)*168/136);
		if(Trigg[TRIGG_BUF].Value2==0)x0=229+(T0_POSI/30)*168/136;
		y0=216,color=CYAN;
		__Point_SCR(x0-1,  y0+10);for(j=0;j<2;j++)__LCD_SetPixl(color);
		__Point_SCR(x0-2,  y0+10);for(j=0;j<2;j++)__LCD_SetPixl(color);
     	__Point_SCR(x0,  y0);
    	for(j=0; j<12; ++j) __LCD_SetPixl(color); 
    	__Point_SCR(x0+1,  y0);
    	for(j=0; j<12; ++j) __LCD_SetPixl(color);
 		__Point_SCR(x0+2,  y0+10);for(j=0;j<2;j++)__LCD_SetPixl(color);
		__Point_SCR(x0+3,  y0+10);for(j=0;j<2;j++)__LCD_SetPixl(color);
//-------PAGE POSI-----------------------------------------------
			if(Trigg[TRIGG_BUF].Value2<Trigg[TRIGG_BUF].Limit2)
			{
				color=GRN;
				x0=229+BufModulus[Trigg[TRIGG_BUF].Value2]/30*168/136;
				__Point_SCR(x0,  y0);
    		for(j=0; j<12; ++j) __LCD_SetPixl(color); 
    		__Point_SCR(x0+1,  y0);
    		for(j=0; j<12; ++j) __LCD_SetPixl(color); 
			}
//---------------------------------------------------------------
    _X_View.Flag &= ~UPDAT;
  }
}
/*
void Update_View_Area(void)
{  
  s16 i, j, k;
  {
    __Point_SCR(89,  0);
    for(j=0; j<12; ++j) __LCD_SetPixl(ORANGE); 
    __Point_SCR(90,  0);
    for(j=0; j<12; ++j) __LCD_SetPixl(ORANGE); 
    __Point_SCR(308, 0);
    for(j=0; j<12; ++j) __LCD_SetPixl(ORANGE); 
    __Point_SCR(309, 0);
    for(j=0; j<12; ++j) __LCD_SetPixl(ORANGE); 

    for(i=91; i<307; i+=8){
      for(j=0; j<8; ++j){
        __Point_SCR(i+j, 0);
        for(k=0; k<12; ++k){
          if((0x01 << k)& RULE_BASE[j]) __LCD_SetPixl(ORANGE);
          else                          __LCD_SetPixl(BLACK);
        }
      }
    }
    __Point_SCR(0  + 91 + (_X_posi.Value * 200)/3796, 0); 
    for(j=0;j<9;++j) __LCD_SetPixl(WHT);
    __Point_SCR(15 + 91 + (_X_posi.Value * 200)/3796, 0);
    for(j=0;j<9;++j) __LCD_SetPixl(WHT);
    for(i=0;i<16;++i){
      __Point_SCR(i + 91 +(_X_posi.Value * 200)/3796, 0);
      __LCD_SetPixl(WHT);
      __Point_SCR(i + 91 +(_X_posi.Value * 200)/3796, 9);
      __LCD_SetPixl(WHT);
    }
    _X_View.Flag &= !UPDAT;
  }
}*/
/******************************** END OF FILE *********************************/
